const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;
#define vec2 float2
#define vec3 float3
#define vec4 float4

#define MAKE_GREY(b, g, r) ((29.0f * (b) + 150.0f * (g) + 76.0f * (r) + 255.0f) / 256.0)
#define ChannelBlend_SoftLight(B,L)  (((L < 128.0f)?(2.0f*((B / 2.0f)+64.0f)*L)/255.0f:(255.0-(2.0f*(255.0f-((B / 2.0f)+64.0f))*(255.0f-L)/255.0f))))

vec4 INPUTSRC(image2d_t src_data,__global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc).zyxw;
}

vec4 INPUT(image2d_t src_data, vec2 tc)
{
	return read_imagef(src_data, sampler, tc).zyxw;
}


__kernel void MAIN(
					__read_only image2d_t input1,
					__read_only image2d_t input2,
					__read_only image2d_t input3,
					__write_only image2d_t dstImg,
					__global FilterParam* param, 
					int alpha)
{

	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[0];;
	float iGlobalTime = param->cur_time / param->total_time;
	
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 tc = (vec2)(fragCoord.x + 0.5f, fragCoord.y + 0.5f)/resolution.xy;
	
	vec4 col = INPUTSRC(input1, param, tc);
	vec4 inBGRA = col;
    col = col * (vec4)(255.0f);
    
    float rtemp, gtemp, btemp, gray;
	
    btemp = fabs(col.z - 17.0f);
    gtemp = fabs(col.y - 39.0f);
    rtemp = fabs(col.x - 135.0f);
    
    col.z = (92.0f * btemp + 163.0f * col.z) / 256.0f;
	col.y = (92.0f * gtemp + 163.0f * col.y) / 256.0f;
	col.x = (92.0f * rtemp + 163.0f * col.x) / 256.0f;
 
    gray = MAKE_GREY(col.z, col.y, col.x);
    
    rtemp = ChannelBlend_SoftLight(INPUT(input2, (vec2)(gray/256.0f, 0.1666f)).x * 256.0f, col.x);
	gtemp = ChannelBlend_SoftLight(INPUT(input2, (vec2)(gray/256.0f, 0.5f)).y * 256.0f, col.y);
	btemp = ChannelBlend_SoftLight(INPUT(input2, (vec2)(gray/256.0f, 0.8333f)).z * 256.0f, col.z);
    
    col.x = INPUT(input3, (vec2)(rtemp/256.0f, 0.1666f)).x;
	col.y = INPUT(input3, (vec2)(gtemp/256.0f, 0.1666f)).x;
	col.z = INPUT(input3, (vec2)(btemp/256.0f, 0.1666f)).x;
	
	write_imagef(dstImg, gl_FragCoord,inBGRA.zyxw*(1.0f - (float)alpha/100.0f)+col.zyxw*(float)alpha/100.0f); 
	
}
